/*
 * SplitStoryChainsPerPage.jsx
 * Javascript for InDesign CS5, CS4, CS3
 * Version date: 20120427
 * 
 * Splits a document's stories into separate (i.e., unthreaded) text frames.
 * 
 * Note: Any overset text at the end of the story will be deleted.
 * Note: Hyphenation points between text frames will not be retained.
 * 
 * For more on InDesign scripting, go to http://www.adobe.com/products/indesign/xml_scripting.html
 * or visit the InDesign Scripting User to User forum at http://www.adobeforums.com
 *
 * DISCLAIMER:
 * ===============
 * Absolutely no warranty. Use it as is or modify it to match your needs
 *
 * Author: Andreas Imhof, www.aiedv.ch
 */

var theDocument = null;
var totalPages = 0;
var totalTextFrames = 0;
var totalSplittableTextFrames = 0;
var actuallySplittedTextFrames = 0;
var pageParentStoriesArray = new Array();
var pageChaines = 0;
var splitAllTextFrames = false;	// split all chained frames or those at end of page only 
								// (keep frames chained when on same page)
var DEBUG = 0;


var silentMode = 0; 
var appVersion = app.version;
var is_CS3_or_later = true;
if ((appVersion.indexOf("5") == 0) || (appVersion.indexOf("6") == 0)) is_CS3_or_later = true;
else is_CS3_or_later = false;

try {
	var splitAllTextFramesStr = app.scriptArgs.getValue("splitAllTextFrames");
	if (splitAllTextFramesStr == "1") splitAllTextFrames = true;
	else splitAllTextFrames = false;
}
catch(e) {}

var orig_enableRedraw = app.scriptPreferences.enableRedraw;
app.scriptPreferences.enableRedraw = false;

init();

app.scriptPreferences.enableRedraw = orig_enableRedraw;
/*
try {
	app.activeDocument.recompose();
} catch (e) {}
*/

//var str_totalSplittableTextFrames = "" + totalSplittableTextFrames;
//app.scriptArgs.setValue("totalSplittedTextFrames", str_totalSplittableTextFrames);
var str_actuallySplittedTextFrames = "" + actuallySplittedTextFrames;
app.scriptArgs.setValue("totalSplittedTextFrames", str_actuallySplittedTextFrames);

function init() {
	if(app.documents.length <= 0) {
		alert("No document to split");
		return;
	}
	theDocument = app.activeDocument;
	totalPages =  theDocument.pages.length;
	app.selection = NothingEnum.nothing;
	
	try { theDocument.layers.everyItem().locked = false; } catch(e){}

	// check if we have text anchors to external documents - we MUST open the destination document or the link will be broken
	// also, if a document contains source AND destination anchors, the destination link pages MUST NOT BE split or the destination anchors get forgotten
	try {	// to do...
		//hyperlink_text_sources = theDocument.hyperlinkTextSources;
		//alert(hyperlink_text_sources.length );
	} catch(e) {}

	scanPages();
	/*
	alert("totalPages: " + totalPages
		+ "\ntotalTextFrames: " + totalTextFrames
		+ "\ntotalSplittableTextFrames: " + totalSplittableTextFrames
		+ "\npageChaines: " + pageChaines
		);
	*/
}

function scanPages() {
	var pageTextFramesChainsArray = new Array();

	// find all parent (of chained) stories
	var pagectr = 0;
	for (pagectr = 0; pagectr < theDocument.pages.length; pagectr++) {
		// search for chained text frames in group and ungroup them (otherwise they cannot be splitted)
		var killedGroups = true;
		var loopcnt = 0;
		while ((loopcnt <= 10) && killedGroups) {
			if (theDocument.pages.item(pagectr).groups.length <= 0) break;
			loopcnt++
			killedGroups = false;	// will be reset if we actually removed groupings
			var groupsToUngroup = new Array();
			//alert("groups on page #"+pagectr+", num groups: "+theDocument.pages.item(pagectr).groups.length);
			for (var i = 0; i < theDocument.pages.item(pagectr).groups.length; i++) {
				var agroup = theDocument.pages.item(pagectr).groups.item(i);
				var textframesingroup = groupHasChainedTextContainers(agroup);
				//alert("page #"+pagectr+ ", group #"+i+" has "+textframesingroup+ " textFrames");
				if (textframesingroup > 0) {
					groupsToUngroup[groupsToUngroup.length] = agroup;
				}
			}
			// ungroup the groups containing chained text frames and restart
			if (groupsToUngroup.length > 0) {
				//alert("groups to kill on page #"+pagectr+": "+groupsToUngroup.length);
				for (var g = 0; g < groupsToUngroup.length; g++) {
					killedGroups = true;	// we have killed groups: recheck all groups on this page for mere "group in group"
					try { 
						groupsToUngroup[g].locked = false;
					} catch (e) {}
					try {
						groupsToUngroup[g].ungroup();
					} catch (e) {}
				}
			}
		}
		//alert("boxes to split on page: " + pagectr + "\nnumber of loops used: " + loopcnt);

		if (theDocument.pages.item(pagectr).textFrames.length <= 0) continue;

		for (var framectr = 0; framectr < theDocument.pages.item(pagectr).textFrames.length; framectr++) {
			totalTextFrames++;
			var theTextFrame = theDocument.pages.item(pagectr).textFrames.item(framectr);


			// get first boxes of a chain only
			if ( theTextFrame.parentStory.textContainers.length != 1) {	// is a chained box?
				// check if this a TOC story within chained text boxes
				if ((theTextFrame.id == theTextFrame.parentStory.textContainers[0].id) && (theTextFrame.parentStory.storyType == StoryTypes.TOC_STORY)) {
					if (theTextFrame.label.indexOf("*TOC*") < 0) theTextFrame.label = "*TOC*"+theTextFrame.label;	// mark it as *TOC* otherwise the TOC is lost after splitting
					//alert("*TOC*");
				}
				addParentStory(theTextFrame.parentStory,pagectr,theTextFrame,(DEBUG ? theTextFrame.contents.substr(0,150) : null));
			}
		}
	}
	totalSplittableTextFrames = pageParentStoriesArray.length;
	if (totalSplittableTextFrames > 0) {
		if (DEBUG > 0) dumpStoryFrames("w","Page Stories BEFORE removing those on same page\n------------------------------------\n");
		if (splitAllTextFrames == false) removeStoriesOnSamePage();	// remove those stories from the list whose chained boxes are all on the same page
		if (DEBUG > 0) dumpStoryFrames("e","Page Stories BEFORE sequence sort\n------------------------------------\n");
		sortStoryFrames();			// sort all story boxes into correct read sequence per page.
		splitStoryPages();
		if (DEBUG > 0) dumpStoryFrames("e","\nPage Stories AFTER sequence sort and SPLIT\n------------------------------------\n");
		removeOriginalStories();
	}
	return;
}

function groupHasChainedTextContainers(thegroup) {
	var textframesingroup = thegroup.textFrames.length;
	//alert("textframesingroup: " + textframesingroup);
	for (var j = 0; j < textframesingroup; j++) {
		if (splitAllTextFrames == true) {
			if (thegroup.textFrames.item(j).parentStory.textContainers.length != 1) return(textframesingroup);
		}
		else {	// split at page boundary only: check if all chained boxes are on same page or not
			var grouppage = get_object_page(thegroup);
			var numStoryTextContainers = thegroup.textFrames.item(j).parentStory.textContainers.length;
			//alert("grouppage: " + grouppage + ", numStoryTextContainers: " + numStoryTextContainers);
			if (numStoryTextContainers > 1) {
				for (var tc = 0; tc < numStoryTextContainers; tc++) {
					var onpage = get_object_page(thegroup.textFrames.item(j).parentStory.textContainers[tc]);
					//alert("page: " + grouppage + "\nstory textContainer #" + tc + " on page: " + onpage );
					if ((onpage != null) && (onpage != grouppage)) return(textframesingroup);
				}
			}
		}
	}
	var groupsingroup = thegroup.groups;
	for (var g = 0; g < groupsingroup.length; g++) {
		textframesingroup = groupHasChainedTextContainers(groupsingroup[g]);
		var grouppage = get_object_page(groupsingroup[g]);
		for (var j = 0; j < textframesingroup; j++) {
			if (splitAllTextFrames == true) {
				if (groupsingroup[g].textFrames.item(j).parentStory.textContainers.length != 1) return(textframesingroup);
			}
			else {	// split at page boundary only: check if all chained boxes are on same page or not
				var numStoryTextContainers = groupsingroup[g].textFrames.item(j).parentStory.textContainers.length;
				if (numStoryTextContainers > 1) {
					for (var tc = 0; tc < numStoryTextContainers; tc++) {
						var onpage = get_object_page(groupsingroup[g].textFrames.item(j).parentStory.textContainers[tc]);
						//alert("group #"+ g + " on page: " + grouppage + "\nstory textContainer #" + tc + " on page: " + onpage);
						if ((onpage != null) && (onpage != grouppage)) return(textframesingroup);
					}
				}
			}
		}
	}
	return(0);
}
function get_object_page(obj) {
	if (obj == null) return(null);
	var myobj = obj;
	var loopcnt = 0;
	while (myobj != null) {
		//listProperties(myobj, true);
		if (typeof(myobj.parentPage) != "undefined") {	// defined for page objects in CS5
			//alert("2 get_object_page for \nmyobj: " + myobj + "\nparentPage.documentOffset: " + myobj.parentPage.documentOffset);
			//listProperties(myobj, true);
			try { return(myobj.parentPage.documentOffset) }
			catch (e) {}
		}
		if (typeof(myobj.documentOffset) != "undefined") {	// defined for page objects CS3-4
			//alert("2 get_object_page for \nmyobj: " + myobj + "\ndocumentOffset: " + myobj.documentOffset);
			//listProperties(myobj, true);
			try { return(myobj.documentOffset) }
			catch (e) {}
		}
		if (myobj.parent == myobj) break;	// we are at Application level
		myobj = myobj.parent;
		loopcnt++;
		if (loopcnt > 20) break;	// dead lock break
	}
	return(null);
}

function addParentStory(theParentStory,thePageNbr,theTextFrame,content) {
	var cntr = 0;
	for (cntr = 0; cntr < pageParentStoriesArray.length; cntr++) {
		if (pageParentStoriesArray[cntr][0] == theParentStory) break;
	}
	var mycontent = "";
	if (content) {
		mycontent = "" + content;
		var re = /\r/g;		// Line separator
		mycontent = mycontent.replace(re,'+');
	}
	if (cntr >= pageParentStoriesArray.length) {
		theParentStory.label = expandLabel(theParentStory.label, "prnt" + theParentStory.id + ":")
		//alert("theParentStory.label: " + theParentStory.label);
		pageParentStoriesArray[pageParentStoriesArray.length] = new Array();
		pageParentStoriesArray[pageParentStoriesArray.length - 1][0] = theParentStory;
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1] = new Array();
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0] = new Array();
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][0] = thePageNbr;
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][1] = theTextFrame;
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][2] = theTextFrame.id;	// old id
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][3] = "prnt" + theParentStory.id + ":";
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][4] = "";
		pageParentStoriesArray[pageParentStoriesArray.length - 1][1][0][5] = mycontent;
		//alert("added parent story: " + theParentStory.id);
	}
	else {
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length] = new Array();
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][0] = thePageNbr;
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][1] = theTextFrame;
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][2] = theTextFrame.id;
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][3] = "prnt" + theParentStory.id + ":";
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][4] = "";
		pageParentStoriesArray[cntr][1][pageParentStoriesArray[cntr][1].length - 1][5] = mycontent;
		//alert("enhanced parent story: " + theParentStory.id + " with frame: " + theTextFrame.id);
	}
	// set a frame label to find it later again
	theTextFrame.label = expandLabel(theTextFrame.label, "tf" + theTextFrame.id + ":");
	//alert("addParentStory: theTextFrame.label: " + theTextFrame.label);
	return;
}


function splitStoryPages () {
	if (pageParentStoriesArray.length <= 0) return;
	// duplicate all story frames
	var newpageitem = null;
	for (var cnt = 0; cnt < pageParentStoriesArray.length ; cnt++) {
		if (pageParentStoriesArray[cnt][0] == null) continue;
		for (var cnt1 = pageParentStoriesArray[cnt][1].length-1; cnt1 >=0; cnt1--) {	// do backwards to avoid wrong references!!!!!
			// find box
			var page = parseInt(pageParentStoriesArray[cnt][1][cnt1][0]);
			if (DEBUG > 0) message("Splitting Stories on Page: " + page + "          ...");
			var idToFind = "tf" + pageParentStoriesArray[cnt][1][cnt1][2] + ":";
			var theTextFrame = null;
			// find box with label
			for (var framectr = 0; framectr < theDocument.pages.item(page).textFrames.length; framectr++) {
				theTextFrame = theDocument.pages.item(page).textFrames.item(framectr);
				if (theTextFrame.label.indexOf(idToFind) >= 0) {
					//alert("ID found: " + idToFind + "\nin theTextFrame.label: " + theTextFrame.label);
					break;
				}
			}
			if (theTextFrame == null) continue;
			pageParentStoriesArray[cnt][1][cnt1][4] = pageParentStoriesArray[cnt][1][cnt1][3] + "," + cnt1 + ";tf" + pageParentStoriesArray[cnt][1][cnt1][2] + ":"
								+ (theTextFrame.previousTextFrame != null ? (";pf" + theTextFrame.previousTextFrame.id + ":") : (";"))
								+ (theTextFrame.nextTextFrame != null ? (";nf" + theTextFrame.nextTextFrame.id + ":") : (";")) + ";//";

			newpageitem = theTextFrame.duplicate();
			actuallySplittedTextFrames++;
			newpageitem.label = expandLabel(newpageitem.label, pageParentStoriesArray[cnt][1][cnt1][4])
			//alert("newpageitem.label: " + newpageitem.label);
		}
		if (DEBUG > 0) message("");
	}
	
	if (splitAllTextFrames == true) return;
	// rechain the duplicated frames page-wise
	for (var cnt = 0; cnt < pageParentStoriesArray.length ; cnt++) {
		var theTextFrame1 = null;
		var theTextFrame2 = null;
		var found1 = false;
		var found2 = false;
		var idToFind1 = "";
		var idToFind2 = "";
		for (var cnt1 = 0; cnt1 < pageParentStoriesArray[cnt][1].length - 1; cnt1++) {
			if (pageParentStoriesArray[cnt][0] == null) continue;
			var page = pageParentStoriesArray[cnt][1][cnt1][0];
			if (DEBUG > 0) message("Re-chaining " + pageParentStoriesArray[cnt][1].length + " duplicated frames on page: " + page + " ...");
			if (pageParentStoriesArray[cnt][1][cnt1 + 1][0] != page) {
				found1 = false;
				found2 = false;
				continue; // is now single box
			}
			// find next box in chain with label
			if (!found1) {
				idToFind1 = pageParentStoriesArray[cnt][1][cnt1][4];
				for (var framectr = 0; framectr < theDocument.pages.item(page).textFrames.length; framectr++) {
					//alert("RECHAIN ? " + idToFind1 + "\nwith tetxFrame.label: \n" + theDocument.pages.item(page).textFrames.item(framectr).label);
					if (theDocument.pages.item(page).textFrames.item(framectr).label.indexOf(idToFind1) >= 0) {	// is chained
						theTextFrame1 = theDocument.pages.item(page).textFrames.item(framectr);
						found1 = true;
						break;
					}
				}
			}
			idToFind2 = pageParentStoriesArray[cnt][1][cnt1 + 1][4];
			for (var framectr = 0; framectr < theDocument.pages.item(page).textFrames.length; framectr++) {
				if (theDocument.pages.item(page).textFrames.item(framectr).label.indexOf(idToFind2) >= 0) {	// is chained
					theTextFrame2 = theDocument.pages.item(page).textFrames.item(framectr);
					found2 = true;
					break;
				}
			}
			//alert("to find for rechain " + idToFind1 + "\nwith: \n" + idToFind2);
			if (found1 && found2) {
				//alert("rechain " + idToFind1 + " with " + idToFind2);
				try {
					theTextFrame1.nextTextFrame = theTextFrame2;
				} catch (e) {
					if (DEBUG > 0) {
						alert("FAIL chain textframes on page: " + page + "\ntheTextFrame1.id: " + theTextFrame1.id
								+ "\ntheTextFrame1.nextTextFrame: " + theTextFrame1.nextTextFrame
								+ "\ntheTextFrame2.id: " + theTextFrame2.id
								+ "\nidToFind1: " + idToFind1 + "\nidToFind2: " + idToFind2
								+ "\ncontent: " + idToFind2);
						//return;
					}
				}
				try {
					idToFind1 = idToFind2;
					theTextFrame1 = theTextFrame2;
				} catch (e) {
					if (DEBUG > 0) {
						alert("FAIL page: " + page + "\ntheTextFrame1: " + theTextFrame1
								+ "\ntheTextFrame1.nextTextFrame: " + theTextFrame1.nextTextFrame
								+ "\ntheTextFrame2: " + theTextFrame2
								+ "\nidToFind1: " + idToFind1 + "\nidToFind2: " + idToFind2
								+ "\ncontent: " + idToFind2);
						//return;
					}
				}
			}
			found2 = false;
		}
		if (DEBUG > 0) message("");
	}
	return;
}


// remove those stories from the list whose chained boxes are all on the same page
function removeStoriesOnSamePage () {
	var cnt = 0;
	for (var cnt = 0; cnt < pageParentStoriesArray.length ; cnt++) {
		var apage = pageParentStoriesArray[cnt][1][0][0];
		var allOnSamePage = true;
		for (var cnt1 = 0; cnt1 < pageParentStoriesArray[cnt][1].length; cnt1++) {
			var otherpage = pageParentStoriesArray[cnt][1][cnt1][0];
			if (otherpage != apage) {
				allOnSamePage = false;
				break;
			}
		}
		if (allOnSamePage == true) {
			//alert("all on same page: " + pageParentStoriesArray[cnt][0].id);
			pageParentStoriesArray[cnt][0] = null;
		}
	}
}


// sort all stories into correct sequence per page.
function sortStoryFrames () {
	for (var cnt = 0; cnt < pageParentStoriesArray.length ; cnt++) {
		if (pageParentStoriesArray[cnt][0] == null) continue;
		var myStory = pageParentStoriesArray[cnt][0];

		var realSequence = -1;
		var sequenceId = null;
		for (var realSequence = 0; realSequence < myStory.textContainers.length; realSequence ++) {	// the real frame sequence in a story
			try {
				sequenceId = myStory.textContainers[realSequence].id;		// frame id in sequence
				anId = pageParentStoriesArray[cnt][1][realSequence][2];
				if (sequenceId == anId) continue;	// is in correct sequence
				// move a frame into correct sequence
				// find the frame which should be in this position
				var cnt1 = 0;
				for (cnt1 = 0; cnt1 < pageParentStoriesArray[cnt][1].length; cnt1++) {
					try {
						anId = pageParentStoriesArray[cnt][1][cnt1][2];
						if (sequenceId == anId) {	// swap
							var s = pageParentStoriesArray[cnt][1][realSequence];
							pageParentStoriesArray[cnt][1][realSequence] = pageParentStoriesArray[cnt][1][cnt1];
							pageParentStoriesArray[cnt][1][cnt1] = s;
						}
					} catch (e) {}
				}
			} catch (e) {}
		}

	}
}



function dumpStoryFrames (mode,title) {
	var dumpFile = new File("~/dumpStoryFrames.dmp");
	//alert("dump: " + dumpFile.fsName);
	var err = 0;
	if (mode == "w") err = dumpFile.open("w");		// new file
	else {
		var filesize = dumpFile.length;
		err = dumpFile.open("e");			// append
		err = dumpFile.seek(filesize,0);	// go eof
	}
	if (title && (title != "")) err = dumpFile.write(title);

	for (var cnt = 0; cnt < pageParentStoriesArray.length; cnt++) {
		if (pageParentStoriesArray[cnt][0] == null) err = dumpFile.write("Story.id = '0000'  #frames: " + pageParentStoriesArray[cnt][1].length + "\n");
		else err = dumpFile.write("Story.id = '" + pageParentStoriesArray[cnt][0].id + "'  #frames: " + pageParentStoriesArray[cnt][1].length + "\n");
		for (var cnt1 = 0; cnt1 < pageParentStoriesArray[cnt][1].length; cnt1++) {
			err = dumpFile.write("     Page: " + pageParentStoriesArray[cnt][1][cnt1][0] + "     Frame: " + pageParentStoriesArray[cnt][1][cnt1][1].id + "     ParentLabel: " + pageParentStoriesArray[cnt][1][cnt1][3] + "     newFrameLabel: " + pageParentStoriesArray[cnt][1][cnt1][4] + "     content: " + pageParentStoriesArray[cnt][1][cnt1][5] + "\n");
		}
	}
	err = dumpFile.close();
}


function removeOriginalStories() {
	for (var cnt = 0; cnt < pageParentStoriesArray.length ; cnt++) {
		if (pageParentStoriesArray[cnt][0] == null) continue;
		var theStoryLabel = pageParentStoriesArray[cnt][1][0][3];
		var theStoryPage = pageParentStoriesArray[cnt][1][0][0];
		for (var framectr = 0; framectr < theDocument.pages.item(theStoryPage).textFrames.length; framectr++) {
			var theTextFrame = theDocument.pages.item(theStoryPage).textFrames.item(framectr);
			if (theTextFrame.parentStory.label.indexOf(theStoryLabel) >= 0) {
				//alert("REMOVE theStoryLabel: " + theStoryLabel + "\nparentStory.label: " + theTextFrame.parentStory.label);
				doRemoveStoryFrames (theTextFrame.parentStory);
				break;
			}
		}
	}
}


function doRemoveStoryFrames (myStory) {
	//Remove each text frame in the story. Iterate backwards to avoid invalid references.
	for(var myCounter = myStory.textContainers.length-1; myCounter >= 0; myCounter --){
		try {
			myStory.textContainers[myCounter].locked = false;
			myStory.textContainers[myCounter].remove();
		} catch(e) {
			alert("This document contains locked stories and therefore can not be split/unchained!\nStory text: " + myStory.textContainers[myCounter].contents.substr(0,150));
			app.activeDocument.revert(true);
			return;
		}
	}
}

function expandLabel(origLabel, addLabel) {
	var newLabel = "" + origLabel;
	if (startsWith(addLabel,"##") == true) newLabel += addLabel;
	else {
		if ((newLabel != "") && (endsWith(newLabel,"##") == false)) newLabel += "##";
		newLabel += addLabel;
	}
	if (endsWith(newLabel,"##") == false) newLabel += "##";
	return (newLabel);
}

function startsWith (str,subs) { return (str.match("^"+subs)==subs); }
function endsWith (str,subs) { return (str.match(subs+"$")==subs); }




var messageWindow = null;
function messageClose() {
	if (!is_CS3_or_later) return;
	if (messageWindow != null) {
		try { messageWindow.close(); } catch(e){}
		messageWindow = null;
	}
}
function message(mess) {
	if (!is_CS3_or_later) return;
	if ( silentMode < 0 ) return;
	if ((mess == null) || (mess == "")) {
		messageClose();
		return;
	}
	try {
		if (messageWindow == null) messageCreate(mess);
		else messageWindow.messtext.text = mess;
		messageWindow.show();
		messageWindow.update();
	} catch(e){}
	return;
}
function messageCreate(mess) {
	try {
		messageWindow = new Window('window', 'Progress', undefined, {maximizeButton:false, minimizeButton:false});
		messageWindow.messageGroup = messageWindow.add('group');
		messageWindow.messageGroup.orientation = 'row';
		messageWindow.messageGroup.margins = [50,30,50,30];
		messageWindow.messtext = messageWindow.messageGroup.add('statictext', undefined, mess);
	} catch(e){}
	return;
}



function listProperties(the_prop_to_query, show) {
	var props_arr = the_prop_to_query;
	var props = the_prop_to_query.reflect.properties;
	var pstr = "Properties-----------------------------------------------\n";
	for (var i = 0; i < props.length; i++) {
		try {
			pstr += props[i].name + ", ";
			/*
			pstr += "Prop Name: '" + props[i].name + "'"
				+ "      Type: '" + typeof(props_arr[props[i].name]) + "'\n"
				+ "      Content: '" + props_arr[props[i].name].toString().substr(0,40) + "'\n";
			*/
		} catch(e){}
		//pstr += "\n";
		if (props[i].name == "properties") listProperties(props[i], true);
	}
	if ((show == undefined) || (show == true)) alert(pstr);
	return(pstr);
}

